/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.base.VWDebug;
import filenet.vw.integrator.adaptors.jms.VWEventItem;
import filenet.vw.integrator.adaptors.jms.VWEventTableModel;
import filenet.vw.integrator.adaptors.jms.VWParameterTableModel;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWEventPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
DocumentListener,
IVWToolbarBorderActionListener {
    private VWToolbarBorder m_eventsToolBar = null;
    private VWTable m_eventTable = null;
    private JTextArea m_descriptionTextArea = null;
    private VWToolbarBorder m_parametersToolBar = null;
    private VWTable m_parameterTable = null;
    private JDialog m_parentDialog = null;
    private VWEventTableModel m_eventTableModel = null;
    private VWParameterTableModel m_parameterTableModel = null;

    public VWEventPanel(JDialog parentDialog) {
        this.m_parentDialog = parentDialog;
        this.createControls();
        this.updateTableSelection(this.m_eventTable, 0);
    }

    public VWEventItem[] getEventItems() {
        if (this.m_eventTableModel != null) {
            return this.m_eventTableModel.getEventItems();
        }
        return null;
    }

    public boolean isModified() {
        return this.m_eventTableModel.isModified() || this.m_parameterTableModel.isModified();
    }

    public void stopEditing() {
        if (this.m_eventTable != null) {
            this.m_eventTable.stopEditing();
        }
        if (this.m_parameterTable != null) {
            this.m_parameterTable.stopEditing();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (event.getSource() == this.m_eventTable.getModel()) {
                    this.updateTableSelection(this.m_eventTable, nRow);
                    break;
                }
                if (event.getSource() != this.m_parameterTable.getModel()) break;
                this.updateTableSelection(this.m_parameterTable, nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource() == this.m_eventTable.getSelectionModel()) {
                this.onSelectedEvent();
            } else if (event.getSource() == this.m_parameterTable.getSelectionModel()) {
                this.onSelectedParameter();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        try {
            if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
                this.onUpdateDescription();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        try {
            if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
                this.onUpdateDescription();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_eventTable.stopEditing();
            this.m_parameterTable.stopEditing();
            if (event.getSource() == this.m_eventsToolBar) {
                int nRowIndex = this.m_eventTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 64: {
                        this.m_eventTableModel.copyItem(nRowIndex);
                        this.m_eventTable.setRowSelectionInterval(this.m_eventTableModel.getRowCount() - 1, this.m_eventTableModel.getRowCount() - 1);
                        break;
                    }
                    case 0x10000000: {
                        this.m_eventTableModel.deleteItem(nRowIndex);
                    }
                }
            } else if (event.getSource() == this.m_parametersToolBar) {
                int nRowIndex = this.m_parameterTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_parameterTableModel.deleteItem(nRowIndex);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.75;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.createEventsPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.25;
            this.add((Component)this.createDescriptionPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.8;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 2;
            this.add((Component)this.createParametersPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createEventsPanel() {
        try {
            this.m_eventsToolBar = new VWToolbarBorder(VWResource.s_events, 0x10000040);
            this.m_eventsToolBar.addToolbarBorderActionNotifier(this);
            JPanel panel = this.m_eventsToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_eventTableModel = new VWEventTableModel(this.m_parentDialog);
            this.m_eventTableModel.addTableModelListener(this);
            this.m_eventTable = new VWTable(this.m_eventTableModel);
            this.m_eventTable.setRowSelectionAllowed(true);
            this.m_eventTable.getSelectionModel().addListSelectionListener(this);
            this.m_eventTable.getSelectionModel().setSelectionMode(0);
            panel.add((Component)new JScrollPane(this.m_eventTable), "Center");
            return this.m_eventsToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createDescriptionPanel() {
        try {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(new VWTitledBorder(VWResource.s_eventDescription));
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            panel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createParametersPanel() {
        try {
            this.m_parametersToolBar = new VWToolbarBorder(VWResource.s_parameters, 0x10000000);
            this.m_parametersToolBar.addToolbarBorderActionNotifier(this);
            JPanel panel = this.m_parametersToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_parameterTableModel = new VWParameterTableModel(this.m_parentDialog);
            this.m_parameterTableModel.addTableModelListener(this);
            this.m_parameterTable = new VWTable(this.m_parameterTableModel);
            this.m_parameterTable.setRowSelectionAllowed(true);
            this.m_parameterTable.getSelectionModel().addListSelectionListener(this);
            this.m_parameterTable.getSelectionModel().setSelectionMode(0);
            panel.add((Component)new JScrollPane(this.m_parameterTable), "Center");
            TableColumn tcElement = this.m_parameterTable.getColumnModel().getColumn(1);
            if (tcElement != null) {
                tcElement.setCellEditor(new DefaultCellEditor(this.m_parameterTableModel.getParameterTypeComboBox()));
            }
            return this.m_parametersToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateTableSelection(JTable table, int nRow) {
        if (table == null) {
            return;
        }
        if (nRow == table.getSelectedRow()) {
            table.clearSelection();
        }
        if (nRow <= table.getRowCount() - 1) {
            table.setRowSelectionInterval(nRow, nRow);
        } else if (table.equals(this.m_parameterTable)) {
            this.onSelectedParameter();
        }
    }

    private void onSelectedEvent() {
        try {
            int nRowIndex = this.m_eventTable.getSelectedRow();
            String name = (String)this.m_eventTableModel.getValueAt(nRowIndex, 0);
            if (name == null || name.length() == 0) {
                int nButtons = 0x10000040;
                this.m_eventsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_eventsToolBar.getClientPanel(), 2, nButtons));
            } else {
                int nButtons = 0x10000040;
                this.m_eventsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_eventsToolBar.getClientPanel(), 1, nButtons));
            }
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.setText((String)this.m_eventTableModel.getValueAt(nRowIndex, 1));
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_parameterTable.stopEditing();
            this.m_parameterTableModel.refresh(this.m_eventTableModel.getRowItemAt(nRowIndex));
            this.updateTableSelection(this.m_parameterTable, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onSelectedParameter() {
        try {
            int nRowIndex = this.m_parameterTable.getSelectedRow();
            String name = (String)this.m_parameterTableModel.getValueAt(nRowIndex, 0);
            if (name == null || name.length() == 0) {
                int nButtons = 0x10000000;
                this.m_parametersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersToolBar.getClientPanel(), 2, nButtons));
            } else {
                int nButtons = 0x10000000;
                this.m_parametersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersToolBar.getClientPanel(), 1, nButtons));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateDescription() {
        try {
            if (this.m_eventTableModel != null && this.m_eventTable != null) {
                int nRowIndex = this.m_eventTable.getSelectedRow();
                String currentDesc = this.m_descriptionTextArea.getText();
                this.m_eventTableModel.setValueAt(currentDesc, nRowIndex, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

